IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_VALOR_LIMITE_UTILIZADO_CONVENIO_MENSAL]'))
DROP VIEW [dbo].V_VALOR_LIMITE_UTILIZADO_CONVENIO_MENSAL
GO

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20230629
'Job.................:  
'Nome................: [V_VALOR_LIMITE_UTILIZADO_CONVENIO_MENSAL]
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 29/06/2023
'Dt Ult Alteracão....: --
'Criado por..........: --
'Alterado por........: Marcos Barros
'=======================================================================================
*/

CREATE VIEW V_VALOR_LIMITE_UTILIZADO_CONVENIO_MENSAL AS
SELECT RC_CLI.CD_EMP,
	   RC_VD_CONV.CD_CTR, 
       RC_VD_CONV.CD_FILIAL, 
       RC_VD_CONV.DT_VD, 
       RC_VD_CONV.DT_FECHA, 
       RC_VD_CONV.CD_CX,
       CASE
           WHEN PDV_VD_RC_VD_CONV.CD_CTR IS NULL
           THEN EST_NF_SAI.NF_NF
           ELSE RC_VD_CONV.NR_ECF
       END NR_ECF, 
       ISNULL(RC_CLI_CONV_RC_CLI.MATRICULA, '') AS MATRICULA, 
       RC_VD_CONV.VLR_CONV,
       CASE
           WHEN SUM((CASE
                         WHEN IR.CD_MEDICO_REC <> 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END)) = 0
           THEN RC_VD_CONV.VLR_CONV
           ELSE SUM((CASE
                         WHEN IR.CD_MEDICO_REC = 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END))
       END AS VLR_CONV_SEM_REC,
       CASE
           WHEN SUM((CASE
                         WHEN IR.CD_MEDICO_REC <> 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END)) > 0
           THEN(RC_VD_CONV.VLR_CONV - SUM((CASE
                                               WHEN IR.CD_MEDICO_REC = 0
                                               THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(RC_VD_CONV.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                                               ELSE 0
                                           END)))
           ELSE SUM((CASE
                         WHEN IR.CD_MEDICO_REC <> 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(RC_VD_CONV.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END))
       END AS VLR_CONV_COM_REC, 
       RC_CLI.CD_CLI, 
       RC_CLI.RZ_CLI,
       CASE
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 0
           THEN 'EM ABERTO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 1
           THEN 'FECHADO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 2
           THEN 'CANCELADO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 3
           THEN 'AMORTIZADO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 4
           THEN 'DEVOLUÇÃO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 5
           THEN 'AGD. FECHAMENTO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 6
           THEN 'GLOSA/PERDA CREDITO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 7
           THEN 'FECHADO/AG PAGAMENTO'
       END AS ST_FECHVD_CONV,
       CASE
           WHEN PDV_VD_IT.CD_VD IS NULL
                AND RC_VD_CONV.ST_FECHVD_CONV = 2
           THEN 'VENDA CANCELADA NO PDV'
           WHEN PDV_VD_IT.CD_VD IS NULL
           THEN 'SEM VINCULO COM CUPOM FISCAL'
           ELSE ''
       END AS STS_VENDA, 
       RC_CLI_CONV.DS_CONV, 
       RC_CLI_CONV.CD_CONV, 
       RC_VD_CONV.PARC, 
       ISNULL(RC_VD_CONV.FLAG_CONV_AFASTADO, 0) AS FLAG_CONV_AFASTADO, 
       ISNULL(RsNcc.VLR_CRED_NCC, 0) AS VLR_CRED_NCC, 
       0 AS TPVENDA, 
       ISNULL(PDV_VD_PROCD_AUDIT.CD_PROCD, 0) AS CD_PROCD, 
       PDV_VD_IT.CD_VD, 
       ISNULL(RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_EMP, 0) AS FLAG_GLOSA_VENDA, 
       ISNULL(RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_EMP, 0) AS FLAG_RATEIO_DESP
FROM RC_VD_CONV
     INNER JOIN RC_CLI ON RC_VD_CONV.CD_EMP = RC_CLI.CD_EMP
                          AND RC_VD_CONV.CD_CLI = RC_CLI.CD_CLI
     LEFT OUTER JOIN RC_CLI_CONV_RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP
                                           AND RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
                                           AND RC_VD_CONV.CD_CONV = RC_CLI_CONV_RC_CLI.CD_CONV
     INNER JOIN RC_CLI_CONV ON RC_VD_CONV.CD_EMP = RC_CLI_CONV.CD_EMP
                               AND RC_VD_CONV.CD_CONV = RC_CLI_CONV.CD_CONV
     LEFT OUTER JOIN PDV_VD_RC_VD_CONV ON RC_VD_CONV.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
                                          AND RC_VD_CONV.CD_CTR = PDV_VD_RC_VD_CONV.CD_CTR
     LEFT OUTER JOIN PDV_VD ON PDV_VD.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
                               AND PDV_VD.CD_FILIAL = PDV_VD_RC_VD_CONV.CD_FILIAL
                               AND PDV_VD.CD_VD = PDV_VD_RC_VD_CONV.CD_VD
     LEFT OUTER JOIN EST_NF_SAI_RC_VD_CONV ON RC_VD_CONV.CD_EMP = EST_NF_SAI_RC_VD_CONV.CD_EMP
                                              AND RC_VD_CONV.CD_FILIAL = EST_NF_SAI_RC_VD_CONV.CD_FILIAL
                                              AND RC_VD_CONV.CD_CTR = EST_NF_SAI_RC_VD_CONV.CD_CTR
     LEFT OUTER JOIN EST_NF_SAI ON EST_NF_SAI_RC_VD_CONV.CD_EMP = EST_NF_SAI.CD_EMP
                                   AND EST_NF_SAI_RC_VD_CONV.CD_FILIAL = EST_NF_SAI.CD_FILIAL
                                   AND EST_NF_SAI_RC_VD_CONV.CD_NF = EST_NF_SAI.CD_NF
     LEFT OUTER JOIN EST_NF_SAI_IT ON EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP
                                      AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
                                      AND EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF
     LEFT OUTER JOIN RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV ON RC_VD_CONV.CD_EMP = RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_EMP
                                                         AND RC_VD_CONV.CD_CTR = RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_CTR
     LEFT OUTER JOIN RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV ON RC_VD_CONV.CD_EMP = RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_EMP
                                                              AND RC_VD_CONV.CD_CTR = RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_CTR
     LEFT OUTER JOIN PDV_VD_IT ON PDV_VD_IT.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
                                  AND PDV_VD_IT.CD_FILIAL = PDV_VD_RC_VD_CONV.CD_FILIAL
                                  AND PDV_VD_IT.CD_VD = PDV_VD_RC_VD_CONV.CD_VD
     LEFT OUTER JOIN PDV_VD_IT_REC IR ON PDV_VD_IT.CD_EMP = IR.CD_EMP
                                         AND PDV_VD_IT.CD_FILIAL = IR.CD_FILIAL
                                         AND PDV_VD_IT.CD_VD = IR.CD_VD
                                         AND PDV_VD_IT.CD_IT = IR.CD_IT
     LEFT OUTER JOIN PDV_VD_PROCD_AUDIT ON PDV_VD_IT.CD_EMP = PDV_VD_PROCD_AUDIT.CD_EMP
                                           AND PDV_VD_IT.CD_FILIAL = PDV_VD_PROCD_AUDIT.CD_FILIAL
                                           AND PDV_VD_IT.CD_VD = PDV_VD_PROCD_AUDIT.CD_VD
     LEFT OUTER JOIN
(
    SELECT RC_VD_CONV_CRED.CD_EMP, 
           RC_VD_CONV_CRED.CD_CTR, 
           SUM(RC_VD_CONV_CRED.VLR_CRED) AS VLR_CRED_NCC
    FROM RC_VD_CONV_CRED
    GROUP BY RC_VD_CONV_CRED.CD_EMP, 
             RC_VD_CONV_CRED.CD_CTR
) RsNcc ON RC_VD_CONV.CD_EMP = RsNcc.CD_EMP
           AND RC_VD_CONV.CD_CTR = RsNcc.CD_CTR
WHERE (PDV_VD.ST_VD = 0 OR EST_NF_SAI.STS_NF = 0)
     AND RC_VD_CONV.CD_CONV NOT IN('')
     AND RC_VD_CONV.VLR_CONV > 0
     AND ST_FECHVD_CONV IN(0, 5, 7)
AND RC_CLI_CONV.TP_CONV IN(0, 4)
GROUP BY RC_CLI.CD_EMP,
		 RC_VD_CONV.CD_FILIAL, 
         RC_VD_CONV.DT_VD, 
         RC_VD_CONV.DT_FECHA, 
         RC_VD_CONV.CD_CX, 
         RC_VD_CONV.NR_ECF, 
         PDV_VD_RC_VD_CONV.CD_CTR, 
         EST_NF_SAI.NF_NF, 
         RC_CLI_CONV_RC_CLI.MATRICULA, 
         RC_CLI.CD_CLI, 
         RC_CLI.RZ_CLI, 
         RC_CLI_CONV.CD_CONV, 
         RC_VD_CONV.ST_FECHVD_CONV, 
         RC_VD_CONV.VLR_CONV, 
         RC_VD_CONV.CD_CTR, 
         PDV_VD_IT.CD_VD, 
         RC_CLI_CONV.DS_CONV, 
         RC_VD_CONV.PARC, 
         RC_VD_CONV.FLAG_CONV_AFASTADO, 
         RsNcc.VLR_CRED_NCC, 
         PDV_VD_PROCD_AUDIT.CD_PROCD, 
         RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_EMP, 
         RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_EMP
UNION ALL
SELECT RC_VD_CONV.CD_EMP,
	   RC_VD_CONV.CD_CTR, 
       RC_VD_CONV.CD_FILIAL, 
       RC_VD_CONV.DT_VD, 
       RC_VD_CONV.DT_FECHA, 
       RC_VD_CONV.CD_CX, 
       RC_VD_CONV.NR_ECF, 
       ISNULL(RC_CLI_CONV_RC_CLI.MATRICULA, '') AS MATRICULA, 
       RC_VD_CONV.VLR_CONV,
       CASE
           WHEN SUM((CASE
                         WHEN IR.CD_MEDICO_REC <> 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END)) = 0
           THEN RC_VD_CONV.VLR_CONV
           ELSE SUM((CASE
                         WHEN IR.CD_MEDICO_REC = 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END))
       END AS VLR_CONV_SEM_REC,
       CASE
           WHEN SUM((CASE
                         WHEN IR.CD_MEDICO_REC <> 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END)) > 0
           THEN(RC_VD_CONV.VLR_CONV - SUM((CASE
                                               WHEN IR.CD_MEDICO_REC = 0
                                               THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                                               ELSE 0
                                           END)))
           ELSE SUM((CASE
                         WHEN IR.CD_MEDICO_REC <> 0
                         THEN CAST(((CAST(PDV_VD_IT.TOT_IT AS NUMERIC(20, 10)) / CAST(PDV_VD.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(PDV_VD.VLR_CONV AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
                         ELSE 0
                     END))
       END AS VLR_CONV_COM_REC, 
       RC_CLI.CD_CLI, 
       RC_CLI.RZ_CLI,
       CASE
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 0
           THEN 'EM ABERTO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 1
           THEN 'FECHADO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 2
           THEN 'CANCELADO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 3
           THEN 'AMORTIZADO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 4
           THEN 'DEVOLUÇÃO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 5
           THEN 'AGD. FECHAMENTO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 6
           THEN 'GLOSA/PERDA CREDITO'
           WHEN RC_VD_CONV.ST_FECHVD_CONV = 7
           THEN 'FECHADO/AG PAGAMENTO'
       END AS ST_FECHVD_CONV,
       CASE
           WHEN PDV_VD_IT.CD_VD IS NULL AND RC_VD_CONV.ST_FECHVD_CONV = 2
           THEN 'VENDA CANCELADA NO PDV'
           WHEN PDV_VD_IT.CD_VD IS NULL
           THEN 'SEM VINCULO COM CUPOM FISCAL'
           ELSE ''
       END AS STS_VENDA, 
       RC_CLI_CONV.DS_CONV, 
       RC_CLI_CONV.CD_CONV, 
       RC_VD_CONV.PARC, 
       ISNULL(RC_VD_CONV.FLAG_CONV_AFASTADO, 0) AS FLAG_CONV_AFASTADO, 
       ISNULL(RsNcc.VLR_CRED_NCC, 0) AS VLR_CRED_NCC, 
       1 AS TPVENDA, 
       ISNULL(PDV_VD_PROCD_AUDIT.CD_PROCD, 0) AS CD_PROCD,
       PDV_VD_IT.CD_VD, 
       ISNULL(RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_EMP, 0) AS FLAG_GLOSA_VENDA, 
       ISNULL(RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_EMP, 0) AS FLAG_RATEIO_DESP
FROM RC_VD_CONV
     INNER JOIN RC_CLI_CONV_DEPENDENTE ON RC_VD_CONV.CD_EMP = RC_CLI_CONV_DEPENDENTE.CD_EMP
                                          AND RC_VD_CONV.CD_CLI = RC_CLI_CONV_DEPENDENTE.CD_CLI_DEPEND
     INNER JOIN RC_CLI ON RC_VD_CONV.CD_EMP = RC_CLI.CD_EMP
                          AND RC_VD_CONV.CD_CLI = RC_CLI.CD_CLI
     LEFT OUTER JOIN RC_CLI_CONV_RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP
                                           AND RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
     INNER JOIN RC_CLI_CONV ON RC_VD_CONV.CD_EMP = RC_CLI_CONV.CD_EMP
                               AND RC_VD_CONV.CD_CONV = RC_CLI_CONV.CD_CONV
     LEFT OUTER JOIN PDV_VD_RC_VD_CONV ON RC_VD_CONV.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
                                          AND RC_VD_CONV.CD_CTR = PDV_VD_RC_VD_CONV.CD_CTR
     LEFT OUTER JOIN RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV ON RC_VD_CONV.CD_EMP = RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_EMP
                                                         AND RC_VD_CONV.CD_CTR = RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_CTR
     LEFT OUTER JOIN RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV ON RC_VD_CONV.CD_EMP = RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_EMP
                                                              AND RC_VD_CONV.CD_CTR = RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_CTR
     LEFT OUTER JOIN PDV_VD ON PDV_VD.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
                               AND PDV_VD.CD_FILIAL = PDV_VD_RC_VD_CONV.CD_FILIAL
                               AND PDV_VD.CD_VD = PDV_VD_RC_VD_CONV.CD_VD
     LEFT OUTER JOIN PDV_VD_IT ON PDV_VD_IT.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
                                  AND PDV_VD_IT.CD_FILIAL = PDV_VD_RC_VD_CONV.CD_FILIAL
                                  AND PDV_VD_IT.CD_VD = PDV_VD_RC_VD_CONV.CD_VD
     LEFT OUTER JOIN PDV_VD_IT_REC IR ON PDV_VD_IT.CD_EMP = IR.CD_EMP
                                         AND PDV_VD_IT.CD_FILIAL = IR.CD_FILIAL
                                         AND PDV_VD_IT.CD_VD = IR.CD_VD
                                         AND PDV_VD_IT.CD_IT = IR.CD_IT
     LEFT OUTER JOIN PDV_VD_PROCD_AUDIT ON PDV_VD_IT.CD_EMP = PDV_VD_PROCD_AUDIT.CD_EMP
                                           AND PDV_VD_IT.CD_FILIAL = PDV_VD_PROCD_AUDIT.CD_FILIAL
                                           AND PDV_VD_IT.CD_VD = PDV_VD_PROCD_AUDIT.CD_VD
     LEFT OUTER JOIN
(
    SELECT RC_VD_CONV_CRED.CD_EMP, 
           RC_VD_CONV_CRED.CD_CTR, 
           SUM(RC_VD_CONV_CRED.VLR_CRED) AS VLR_CRED_NCC
    FROM RC_VD_CONV_CRED
    GROUP BY RC_VD_CONV_CRED.CD_EMP, 
             RC_VD_CONV_CRED.CD_CTR
) RsNcc ON RC_VD_CONV.CD_EMP = RsNcc.CD_EMP
           AND RC_VD_CONV.CD_CTR = RsNcc.CD_CTR
WHERE RC_VD_CONV.VLR_CONV > 0
     AND ST_FECHVD_CONV IN(0, 5, 7)
     AND RC_CLI_CONV.TP_CONV IN(0, 4)
GROUP BY RC_VD_CONV.CD_EMP,
		 RC_VD_CONV.CD_FILIAL, 
         RC_VD_CONV.DT_VD, 
         RC_VD_CONV.DT_FECHA, 
         RC_VD_CONV.CD_CX, 
         RC_VD_CONV.NR_ECF, 
         RC_CLI_CONV_RC_CLI.MATRICULA, 
         RC_CLI.CD_CLI, 
         RC_CLI.RZ_CLI, 
         RC_CLI_CONV.CD_CONV, 
         RC_VD_CONV.ST_FECHVD_CONV, 
         RC_VD_CONV.VLR_CONV, 
         RC_VD_CONV.CD_CTR, 
         PDV_VD_IT.CD_VD, 
         RC_CLI_CONV.DS_CONV, 
         RC_VD_CONV.PARC, 
         RC_VD_CONV.FLAG_CONV_AFASTADO, 
         RsNcc.VLR_CRED_NCC, 
         PDV_VD_PROCD_AUDIT.CD_PROCD, 
         RC_CLI_CONV_GLOSA_RC_DEB_VD_CONV.CD_EMP, 
         RC_CLI_CONV_GLOSA_PG_DESP_RAT_VD_CONV.CD_EMP;